/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui.io.epl;

import com.aptana.core.logging.IdeLog;
import com.aptana.ui.io.epl.IOUIEplPlugin;
import java.io.File;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.EditorSelectionDialog;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class OpenWithMenu
extends ContributionItem {
    private IAdaptable file;
    private IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
    private static Map<ImageDescriptor, Image> imageCache = new Hashtable<ImageDescriptor, Image>(11);
    public static final String ID = "org.eclipse.ui.OpenWithMenu";
    private Client client;
    private static final Comparator<IEditorDescriptor> comparer = new Comparator<IEditorDescriptor>(){
        private Collator collator = Collator.getInstance();

        @Override
        public int compare(IEditorDescriptor o1, IEditorDescriptor o2) {
            String s1 = o1.getLabel();
            String s2 = o2.getLabel();
            return this.collator.compare(s1, s2);
        }
    };

    public OpenWithMenu(IWorkbenchPage page, IAdaptable file, Client client) {
        super(ID);
        this.file = file;
        this.client = client;
    }

    private Image getImage(IEditorDescriptor editorDesc) {
        ImageDescriptor imageDesc = this.getImageDescriptor(editorDesc);
        if (imageDesc == null) {
            return null;
        }
        Image image = imageCache.get(imageDesc);
        if (image == null) {
            image = imageDesc.createImage();
            imageCache.put(imageDesc, image);
        }
        return image;
    }

    private ImageDescriptor getImageDescriptor(IEditorDescriptor editorDesc) {
        IFileStore file = this.getFileResource();
        if (file == null) {
            return null;
        }
        ImageDescriptor imageDesc = null;
        imageDesc = editorDesc == null ? this.registry.getImageDescriptor(file.getName()) : editorDesc.getImageDescriptor();
        if (imageDesc == null && editorDesc.getId().equals("org.eclipse.ui.systemExternalEditor")) {
            imageDesc = this.registry.getSystemExternalEditorImageDescriptor(file.getName());
        }
        return imageDesc;
    }

    private void createMenuItem(Menu menu, final IEditorDescriptor descriptor, IEditorDescriptor preferredEditor) {
        final MenuItem menuItem = new MenuItem(menu, 16);
        boolean isPreferred = preferredEditor != null && descriptor.getId().equals(preferredEditor.getId());
        menuItem.setSelection(isPreferred);
        menuItem.setText(descriptor.getLabel());
        Image image = this.getImage(descriptor);
        if (image != null) {
            menuItem.setImage(image);
        }
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        if (!menuItem.getSelection()) break;
                        OpenWithMenu.this.openEditor(descriptor, false);
                    }
                }
            }
        };
        menuItem.addListener(13, listener);
    }

    private void createOtherMenuItem(final Menu menu) {
        final IFileStore file = this.getFileResource();
        if (file == null) {
            return;
        }
        new MenuItem(menu, 2);
        MenuItem menuItem = new MenuItem(menu, 8);
        menuItem.setText(IDEWorkbenchMessages.OpenWithMenu_Other);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        IEditorDescriptor editor;
                        EditorSelectionDialog dialog = new EditorSelectionDialog(menu.getShell());
                        dialog.setMessage(NLS.bind((String)IDEWorkbenchMessages.OpenWithMenu_OtherDialogDescription, (Object)file.getName()));
                        if (dialog.open() != 0 || (editor = dialog.getSelectedEditor()) == null) break;
                        OpenWithMenu.this.openEditor(editor, editor.isOpenExternal());
                    }
                }
            }
        };
        menuItem.addListener(13, listener);
    }

    public void fill(Menu menu, int index) {
        int n;
        IFileStore file = this.getFileResource();
        if (file == null) {
            return;
        }
        IEditorDescriptor defaultEditor = this.registry.findEditor("org.eclipse.ui.DefaultTextEditor");
        IEditorDescriptor preferredEditor = null;
        try {
            preferredEditor = IDE.getEditorDescriptor((String)file.getName());
        }
        catch (PartInitException e) {
            IdeLog.logError((Plugin)IOUIEplPlugin.getDefault(), (Throwable)e);
        }
        IContentType finalType = null;
        IContentType[] iContentTypeArray = Platform.getContentTypeManager().getAllContentTypes();
        int n2 = iContentTypeArray.length;
        int n3 = 0;
        while (n3 < n2) {
            block16: {
                IContentType type = iContentTypeArray[n3];
                if (finalType != null) break;
                try {
                    String settings;
                    String[] stringArray = type.getSettings(null).getFileSpecs(4);
                    int n4 = stringArray.length;
                    n = 0;
                    while (n < n4) {
                        settings = stringArray[n];
                        if (settings.equals(file.getName())) {
                            finalType = type;
                            break;
                        }
                        ++n;
                    }
                    if (finalType != null) break block16;
                    stringArray = type.getSettings(null).getFileSpecs(8);
                    n4 = stringArray.length;
                    n = 0;
                    while (n < n4) {
                        settings = stringArray[n];
                        if (settings.equals(OpenWithMenu.getExtension(file.getName()))) {
                            finalType = type;
                            break;
                        }
                        ++n;
                    }
                }
                catch (Exception e) {
                    IdeLog.logWarning((Plugin)IOUIEplPlugin.getDefault(), (Throwable)e);
                }
            }
            ++n3;
        }
        IEditorDescriptor[] editors = this.registry.getEditors(file.getName(), finalType);
        Collections.sort(Arrays.asList(editors), comparer);
        boolean defaultFound = false;
        ArrayList<IEditorDescriptor> alreadyMapped = new ArrayList<IEditorDescriptor>();
        IEditorDescriptor[] iEditorDescriptorArray = editors;
        n = editors.length;
        int n5 = 0;
        while (n5 < n) {
            IEditorDescriptor editor = iEditorDescriptorArray[n5];
            if (!alreadyMapped.contains(editor)) {
                this.createMenuItem(menu, editor, preferredEditor);
                if (defaultEditor != null && editor.getId().equals(defaultEditor.getId())) {
                    defaultFound = true;
                }
                alreadyMapped.add(editor);
            }
            ++n5;
        }
        if (editors.length > 0) {
            new MenuItem(menu, 2);
        }
        if (!defaultFound && defaultEditor != null) {
            this.createMenuItem(menu, defaultEditor, preferredEditor);
        }
        IEditorDescriptor descriptor = this.registry.findEditor("org.eclipse.ui.systemExternalEditor");
        this.createMenuItem(menu, descriptor, preferredEditor);
        descriptor = this.registry.findEditor("org.eclipse.ui.systemInPlaceEditor");
        if (descriptor != null) {
            this.createMenuItem(menu, descriptor, preferredEditor);
        }
        this.createOtherMenuItem(menu);
    }

    private IFileStore getFileResource() {
        File file;
        IFileStore fileStore = (IFileStore)this.file.getAdapter(IFileStore.class);
        if (fileStore == null && (file = (File)this.file.getAdapter(File.class)) != null) {
            fileStore = EFS.getLocalFileSystem().fromLocalFile(file);
        }
        return fileStore;
    }

    public boolean isDynamic() {
        return true;
    }

    protected void openEditor(IEditorDescriptor editorDescriptor, boolean openUsingDescriptor) {
        IFileStore file = this.getFileResource();
        if (file == null || this.client == null) {
            return;
        }
        this.client.openEditor(file, editorDescriptor);
    }

    public static String getExtension(String fileName) {
        if (fileName == null || fileName.equals("")) {
            return fileName;
        }
        int index = fileName.lastIndexOf(46);
        if (index == -1) {
            return "";
        }
        if (index == fileName.length()) {
            return "";
        }
        return fileName.substring(index + 1, fileName.length());
    }

    public static interface Client {
        public void openEditor(IFileStore var1, IEditorDescriptor var2);
    }
}

